/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;

class LogCallbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final InheritableThreadLocal<LogOutput> tlTtarget = new InheritableThreadLocal();
    private final Appender<ILoggingEvent> defaultAppender;

    LogCallbackAppender(Appender<ILoggingEvent> defaultAppender) {
        this.defaultAppender = defaultAppender;
    }

    public void setTarget(@Nullable LogOutput target) {
        this.tlTtarget.set(target);
    }

    @Override
    protected void append(ILoggingEvent event) {
        LogOutput target = (LogOutput)this.tlTtarget.get();
        if (target == null) {
            this.defaultAppender.doAppend(event);
            return;
        }
        target.log(event.getFormattedMessage(), LogCallbackAppender.translate(event.getLevel()));
    }

    private static LogOutput.Level translate(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return LogOutput.Level.ERROR;
            }
            case 30000: {
                return LogOutput.Level.WARN;
            }
            case 20000: {
                return LogOutput.Level.INFO;
            }
            case 5000: {
                return LogOutput.Level.TRACE;
            }
        }
        return LogOutput.Level.DEBUG;
    }
}

